/*
* littlefs.h- Sigmastar
*
* Copyright (c) [2019~2020] SigmaStar Technology.
*
*
* This software is licensed under the terms of the GNU General Public
* License version 2, as published by the Free Software Foundation, and
* may be copied, distributed, and modified under those terms.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License version 2 for more details.
*
*/


/*
 * lwfs.h
 */

#ifndef __LITTLEFS_H__
#define __LITTLEFS_H__
#include "lfs.h"
#include "fs_partition.h"


#ifndef O_CREAT
#define O_CREAT     00000100
#endif
#ifndef O_PATH
#define O_PATH      010000000
#endif
#ifndef O_RDWR
#define O_RDWR      00000002
#endif
#ifndef O_WRONLY
#define O_WRONLY    00000001
#endif
#ifndef O_RDONLY
#define O_RDONLY    00000000
#endif
#ifndef O_ACCMODE
#define O_ACCMODE   00000003
#endif


#ifndef SEEK_SET
#define SEEK_SET    0
#endif
#ifndef SEEK_CUR
#define SEEK_CUR    1
#endif
#ifndef SEEK_END
#define SEEK_END    2
#endif


S32 littlefs_mount(char *partition, char *mnt_path);
void littlefs_unmount(void);
void* littlefs_open(char *filename, U32  flags, U32 mode);
S32 littlefs_close(void* fd);
S32 littlefs_read(void* fd, void *buf, U32 count);
S32 littlefs_write(void* fd, void *buf, U32 count);
S32 littlefs_lseek(void* fd, S32 offset, S32 whence);

#endif //__LWFS_H__
